'BlitzSpeech Blitzmax-ng Header
'Written by Michael Denathorn 2025

'Speech flags constants
Const SPF_DEFAULT:Int = 0
Const SPF_ASYNC:Int = 1
Const SPF_PURGEBEFORESPEAK:Int = 2
Const SPF_IS_FILENAME:Int = 4
Const SPF_IS_XML:Int = 8
Const SPF_IS_NOT_XML:Int = 16
Const SPF_PERSIST_XML:Int = 32
Const SPF_NLP_SPEAK_PUNC:Int = 64
Const SPF_PARSE_SAPI:Int = 128
Const SPF_PARSE_SSML:Int = 256

' External function declarations
Extern "Win32"
    ' Core initialization
    Function InitSpeech:Int()
    Function CleanupSpeech()
    
    ' Basic speech functions
    Function SpeakText:Int(text$z)
    Function SpeakTextFlags:Int(text$z, flags_:Int)
    Function SpeakFile:Int(filePath$z)
    
    ' Speech control
    Function PauseSpeech:Int()
    Function ResumeSpeech:Int()
	Function StopSpeech:Int()
    Function IsSpeaking:Int()
    Function WaitUntilSpeechIsDone:Int(timeout_ms:Int)
    
    ' Voice settings
    Function SetSpeechRate:Int(rate:Int)
    Function SetSpeechVolume:Int(volume:Int)
    
    ' Voice management
    Function GetVoiceCount:Int()
    Function GetVoiceName:Byte Ptr(index:Int)
    Function GetVoiceLanguage:Byte Ptr(index:Int)
	Function GetVoiceType:Int(index:Int)
    Function GetCurrentVoice:Int()
    Function SetSpeechVoice:Int(index:Int)
    Function SetSpeechVoiceByName:Int(name$z)
    
	' Voice saving to .WAV file
	Function SpeakToFile:Int(text$z, filepath$z, sampleRate:Int, bitsPerSample:Int, channels:Int, flags_:Int)
	Function SpeakToFileDefault:Int(text$z, filepath$z)
	
    ' File utilities
    Function GetFileEncoding:Int(filepath$z)
	
	'Misc
	Function AboutBlitzSpeech()
End Extern

'Available language constants
'Note: I found installing a different language and the modules 
'a bit of a pig, I tried through settings, which seemed To fail,
'then I tried through powershell, with that hanging.

'Somehow though, I managed to install French, as these voices appeared:

'Microsoft Hortense - French (France) (Language: fr-FR)
'Microsoft Julie - French (France) (Language: fr-FR)
'Microsoft Paul - French (France) (Language: fr-FR)
  
'So bare in mind, installing a language pack might silently succeed.

'BlitzMax will automatically detect them when using
'get_voice_count()
Const SP_LAN_ENGLISH:String = "English"
Const SP_LAN_SPANISH:String = "Spanish"
Const SP_LAN_FRENCH:String = "French"
Const SP_LAN_GERMAN:String = "German"
Const SP_LAN_ITALIAN:String = "Italian"
Const SP_LAN_PORTUGUESE:String = "Portuguese"
Const SP_LAN_DUTCH:String = "Dutch"
Const SP_LAN_RUSSIAN:String = "Russian"
Const SP_LAN_POLISH:String = "Polish"
Const SP_LAN_CHINESE:String = "Chinese"
Const SP_LAN_CHINESE_SIMPLIFIED:String = "Chinese (Simplified)"
Const SP_LAN_CHINESE_TRADITIONAL:String = "Chinese (Traditional)"
Const SP_LAN_JAPANESE:String = "Japanese"
Const SP_LAN_KOREAN:String = "Korean"
Const SP_LAN_ENGLISH_US:String = "English (United States)"
Const SP_LAN_ENGLISH_UK:String = "English (Great Britain)"
Const SP_LAN_ENGLISH_GB:String = "English (Great Britain)"
Const SP_LAN_ENGLISH_AU:String = "English (Australia)"
Const SP_LAN_ENGLISH_CA:String = "English (Canada)"
Const SP_LAN_ENGLISH_IN:String = "English (India)"
Const SP_LAN_ARABIC:String = "Arabic"
Const SP_LAN_CATALAN:String = "Catalan"
Const SP_LAN_CZECH:String = "Czech"
Const SP_LAN_DANISH:String = "Danish"
Const SP_LAN_FINNISH:String = "Finnish"
Const SP_LAN_GREEK:String = "Greek"
Const SP_LAN_HEBREW:String = "Hebrew"
Const SP_LAN_HINDI:String = "Hindi"
Const SP_LAN_HUNGARIAN:String = "Hungarian"
Const SP_LAN_NORWEGIAN:String = "Norwegian"
Const SP_LAN_SWEDISH:String = "Swedish"
Const SP_LAN_THAI:String = "Thai"
Const SP_LAN_TURKISH:String = "Turkish"

'Parameter constants for speak_to_file
' Sample Rates (Hz)
Const SP_SAMPLE_RATE_8000:Int = 8000
Const SP_SAMPLE_RATE_11025:Int = 11025
Const SP_SAMPLE_RATE_16000:Int = 16000
Const SP_SAMPLE_RATE_22050:Int = 22050
Const SP_SAMPLE_RATE_44100:Int = 44100
Const SP_SAMPLE_RATE_48000:Int = 48000

' Bit Depths (bits per sample)
Const SP_BIT_DEPTH_8:Int = 8
Const SP_BIT_DEPTH_16:Int = 16

' Channels
Const SP_CHANNEL_MONO:Int = 1
Const SP_CHANNEL_STEREO:Int = 2

'Error codes for functions, just incase stuff goes
'tits up. Fully commented too.
' ----- INITIALIZATION -----
' InitSpeech() returns:
Const SP_INIT_SUCCESS:Int = 0
Const SP_INIT_ERR_COM_FAILED:Int = -1      ' COM initialization failed
Const SP_INIT_ERR_VOICE_FAILED:Int = -2    ' Failed to create voice instance

' ----- BASIC SPEECH FUNCTIONS -----
' SpeakText() returns:
Const SP_SPEAK_SUCCESS:Int = 0
Const SP_SPEAK_ERR_NOT_INIT:Int = -1       ' Not initialized
Const SP_SPEAK_ERR_NULL_TEXT:Int = -2      ' NULL text pointer
Const SP_SPEAK_ERR_CONV_LEN:Int = -3       ' Failed to get wide string length
Const SP_SPEAK_ERR_CONV_ALLOC:Int = -4     ' Failed to allocate conversion buffer
Const SP_SPEAK_ERR_CONV_FAILED:Int = -5    ' String conversion failed
Const SP_SPEAK_ERR_FAILED:Int = -6         ' SAPI Speak call failed

' SpeakTextFlags() returns: (same as speak_text)
Const SP_SPEAK_FLAGS_SUCCESS:Int = 0
Const SP_SPEAK_FLAGS_ERR_NOT_INIT:Int = -1
Const SP_SPEAK_FLAGS_ERR_NULL_TEXT:Int = -2
Const SP_SPEAK_FLAGS_ERR_CONV_LEN:Int = -3
Const SP_SPEAK_FLAGS_ERR_CONV_ALLOC:Int = -4
Const SP_SPEAK_FLAGS_ERR_CONV_FAILED:Int = -5
Const SP_SPEAK_FLAGS_ERR_FAILED:Int = -6

' ----- FILE FUNCTIONS -----
' SpeakFile() returns:
Const SP_FILE_SUCCESS:Int = 0
Const SP_FILE_ERR_NOT_INIT:Int = -1        ' Not initialized
Const SP_FILE_ERR_NULL_PATH:Int = -2       ' NULL filepath
Const SP_FILE_ERR_CANT_OPEN:Int = -3       ' File not found or can't open
Const SP_FILE_ERR_TOO_LARGE:Int = -4       ' File too large (>10MB) or empty
Const SP_FILE_ERR_ENCODING:Int = -5        ' Encoding conversion failed
Const SP_FILE_ERR_SPEAK_FAILED:Int = -6    ' SAPI Speak call failed

' GetFileEncoding() returns:
Const SP_ENC_ANSI:Int = 0                  ' ANSI/default code page
Const SP_ENC_UTF16_LE:Int = 1              ' UTF-16 Little Endian
Const SP_ENC_UTF16_BE:Int = 2              ' UTF-16 Big Endian
Const SP_ENC_UTF8:Int = 3                  ' UTF-8 (with or without BOM)
Const SP_ENC_ERR_NULL_PATH:Int = -1        ' NULL filepath

' ----- CONTROL FUNCTIONS -----
' PauseSpeech() returns:
Const SP_PAUSE_SUCCESS:Int = 0
Const SP_PAUSE_ERR_NOT_INIT:Int = -1       ' Not initialized
Const SP_PAUSE_ERR_FAILED:Int = -2         ' SAPI Pause call failed

' ResumeSpeech() returns:
Const SP_RESUME_SUCCESS:Int = 0
Const SP_RESUME_ERR_NOT_INIT:Int = -1      ' Not initialized
Const SP_RESUME_ERR_FAILED:Int = -2        ' SAPI Resume call failed

' StopSpeech() returns:
Const SP_STOP_SUCCESS:Int = 0
Const SP_STOP_ERR_NOT_INIT:Int = -1        ' Not initialized
Const SP_STOP_ERR_FAILED:Int = -2          ' SAPI Stop call failed

' IsSpeaking() returns:
Const SP_IS_SPEAKING_YES:Int = 1           ' Currently speaking
Const SP_IS_SPEAKING_NO:Int = 0            ' Not speaking
Const SP_IS_SPEAKING_ERR:Int = -1          ' Error/not initialized

' WaitUntilSpeechIsDone() returns:
Const SP_WAIT_SUCCESS:Int = 0
Const SP_WAIT_ERR_NOT_INIT:Int = -1        ' Not initialized
Const SP_WAIT_ERR_FAILED:Int = -2          ' Wait failed or timed out

' ----- VOICE SETTINGS -----
' SetSpeechRate() returns:
Const SP_RATE_SUCCESS:Int = 0
Const SP_RATE_ERR_NOT_INIT:Int = -1        ' Not initialized
Const SP_RATE_ERR_FAILED:Int = -2          ' SAPI SetRate call failed

' SetSpeechVolume() returns:
Const SP_VOLUME_SUCCESS:Int = 0
Const SP_VOLUME_ERR_NOT_INIT:Int = -1      ' Not initialized
Const SP_VOLUME_ERR_FAILED:Int = -2        ' SAPI SetVolume call failed

' ----- VOICE MANAGEMENT -----
' GetVoiceCount() returns:
' Positive number = voice count
Const SP_VOICE_COUNT_ERR_NOT_INIT:Int = -1      ' Not initialized
Const SP_VOICE_COUNT_ERR_ENUM_FAILED:Int = -2   ' Failed to enumerate voices
Const SP_VOICE_COUNT_ERR_GET_COUNT:Int = -3     ' Failed to get count

' GetCurrentVoice() returns:
' 0 or positive = current voice index
Const SP_GET_VOICE_ERR_NOT_INIT:Int = -1        ' Not initialized
Const SP_GET_VOICE_ERR_NO_VOICE:Int = -2        ' Failed to get current voice
Const SP_GET_VOICE_ERR_NO_ID:Int = -3           ' Failed to get voice ID
Const SP_GET_VOICE_ERR_NO_ENUM:Int = -4         ' Voice enumeration not done
Const SP_GET_VOICE_ERR_NOT_FOUND:Int = -5       ' Current voice not in list

' SetSpeechVoice() returns:
Const SP_SET_VOICE_SUCCESS:Int = 0
Const SP_SET_VOICE_ERR_NOT_INIT:Int = -1        ' Not initialized
Const SP_SET_VOICE_ERR_BAD_INDEX:Int = -2       ' Invalid voice index
Const SP_SET_VOICE_ERR_GET_TOKEN:Int = -3       ' Failed to get voice token
Const SP_SET_VOICE_ERR_FAILED:Int = -4          ' SAPI SetVoice call failed

' SetSpeechVoiceByName() returns:
' 0 or positive = voice index (success)
Const SP_SET_NAME_ERR_NOT_INIT:Int = -1         ' Not initialized or NULL name
Const SP_SET_NAME_ERR_ENUM_FAILED:Int = -2      ' Failed to enumerate voices
Const SP_SET_NAME_ERR_SET_FAILED:Int = -3       ' Found voice but SetVoice failed
Const SP_SET_NAME_ERR_NOT_FOUND:Int = -4        ' Voice name not found

' GetVoiceType() returns:
Const SP_VOICE_TYPE_ERROR:Int = -1				' Not initialized or NULL
Const SP_VOICE_TYPE_DESKTOP:Int = 0				' SAPI 5 platform (Traditional)
Const SP_VOICE_TYPE_ONECORE:Int = 1				' OneCore speech platform (Modern - Win10/11 only)

' ----- VOICE SAVING -----
' SpeakToFile() returns:
Const SP_FILE_OUT_SUCCESS:Int = 0
Const SP_FILE_OUT_ERR_NOT_INIT:Int = -1        ' Not initialized
Const SP_FILE_OUT_ERR_NULL_PARAM:Int = -2      ' NULL text or filepath
Const SP_FILE_OUT_ERR_TEXT_LEN:Int = -3        ' Failed to get text length
Const SP_FILE_OUT_ERR_TEXT_CONV:Int = -4       ' Text conversion failed
Const SP_FILE_OUT_ERR_PATH_LEN:Int = -5        ' Failed to get path length
Const SP_FILE_OUT_ERR_PATH_CONV:Int = -6       ' Path conversion failed
Const SP_FILE_OUT_ERR_CREATE_STREAM:Int = -7   ' Failed to create stream
Const SP_FILE_OUT_ERR_BIND_FILE:Int = -8       ' Failed to bind to file
Const SP_FILE_OUT_ERR_SET_OUTPUT:Int = -9      ' Failed to set output
Const SP_FILE_OUT_ERR_SPEAK_FAILED:Int = -10   ' Speak call failed
























